<#ibiztemplate>
TARGET=PSAPPCODELIST
</#ibiztemplate>
import { CodeListBase } from '@/ibiz-core/code-list/code-list-base';
import { HttpResponse } from '@/ibiz-core/utils';

/**
 * 代码表--${item.getName()}
 *
 * @export
 * @class ${srfclassname('${item.getCodeName()}')}
 * @extends {CodeListBase}
 */
export class ${srfclassname('${item.getCodeName()}')} extends CodeListBase { 
<#if item.getPSAppDataEntity?? && item.getPSAppDataEntity()?? && item.getPSAppDEDataSet?? && item.getPSAppDEDataSet()??>

    /**
     * 代码表项主键标识
     *
     * @protected
     * @type {string}
     * @memberof CodeListBase
     */
    protected idKey: string = '<#if item.getValuePSAppDEField()??>${item.getValuePSAppDEField().getCodeName()?lower_case}<#else>${item.getPSAppDataEntity().getKeyPSAppDEField().codeName?lower_case}</#if>';

    /**
     * 代码表项值项标识
     *
     * @protected
     * @type {string}
     * @memberof CodeListBase
     */
    protected valueKey: string = '<#if item.getValuePSAppDEField()??>${item.getValuePSAppDEField().getCodeName()?lower_case}<#else>${item.getPSAppDataEntity().getKeyPSAppDEField().codeName?lower_case}</#if>';

    /**
     * 代码表项文本标识
     *
     * @protected
     * @type {string}
     * @memberof CodeListBase
     */
    protected textKey: string = '<#if item.getTextPSAppDEField()??>${item.getTextPSAppDEField().getCodeName()?lower_case}<#else>${item.getPSAppDataEntity().getMajorPSAppDEField().codeName?lower_case}</#if>';
</#if>
<#-- 不为子系统代码表 -->
<#if item.isSubSysCodeList() == false>
    <#if item.getPSAppDataEntity?? && item.getPSAppDataEntity()?? && item.getPSAppDEDataSet?? && item.getPSAppDEDataSet()??>

    /**
     * 获取数据项
     *
     * @param {*} [context={}] 上下文
     * @param {*} [data={}] 参数
     * @returns {Promise<any>}
     * @memberof ${srfclassname('${item.getCodeName()}')}
     */
    public async getItems(context: any = {}, data: any = {}): Promise<any> {
        const service: any = await this.getService('${item.getPSAppDataEntity().codeName?lower_case}');
        const response: any = await service.${item.getPSAppDEDataSet().codeName}(context, data);
        if (response && response.status === 200 && response.data) {
            return new HttpResponse(200, this.doItems(response.data));
        }
        return new HttpResponse(200, []);
    }
    </#if>
<#else>
    <#if item.getPSAppDataEntity?? && item.getPSAppDataEntity()?? && item.getPSAppDEDataSet?? && item.getPSAppDEDataSet()??> 
        <#if item.getPSAppDataEntity().codeName == "CodeItem">
    /**
     * 获取数据项
     *
     * @param {*} [context={}] 上下文
     * @param {*} [data={}] 参数
     * @returns {Promise<any>}
     * @memberof ${srfclassname('${item.getCodeName()}')}
     */
    public async getItems(context: any = {}, data: any = {}): Promise<any> {
        const service: any = await this.getService('${item.getPSAppDataEntity().codeName?lower_case}');
        const response: any = await service.${item.getPSAppDEDataSet().codeName}(context, { ...data, codelistid: '${item.id}' });
        if (response && response.status === 200 && response.data) {
            return new HttpResponse(200, this.doItems(response.data));
        }
        return new HttpResponse(200, []);
    }
        </#if>
    </#if>
</#if>
}